script_folder=$HOME/scripts
salt=`head /dev/urandom | tr -dc a-z0-9 | head -c4`
# first dump the scontrol results
script_file=$script_folder/`date +'%Y-%m-%d_%H-%M-%S'`_tt.txt
echo $script_file
scontrol show job | grep "Command" > $script_file

launch_function () {
    TAG=$1
    SCRIPT=$2
    FULL_EVAL_C=$3
    EXTRA_ARGS=$4

    LA=tt
    QUEUE=learnfair,learnlab

    # imagenet
    if [ ! -f "checkpoints/TTT/imagenet/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-o $SCRIPT  \
            --data_path "datasets/imagenet_full_size/061417" \
            --output_dir "checkpoints/TTT/imagenet/$TAG" \
            --dataset_name imagenet \
            $EXTRA_ARGS
    fi

    # imagenet-a
    if [ ! -f "checkpoints/TTT/imagenet_a/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-a $SCRIPT  \
            --data_path "datasets/imagenet_a" \
            --output_dir "checkpoints/TTT/imagenet_a/$TAG" \
            --dataset_name imagenet_a \
            $EXTRA_ARGS
    fi

    # imagenet-c
    for DATASET in 'contrast' 'brightness' 'defocus_blur' 'elastic_transform' 'fog' 'frost' 'gaussian_noise' 'glass_blur' 'impulse_noise' 'jpeg_compression' 'motion_blur' 'pixelate' 'shot_noise' 'snow' 'zoom_blur'; do
        if [ $FULL_EVAL_C = "0" ]; then
            for tar in 5; do
                if [ ! -f "checkpoints/TTT/${DATASET}_${tar}/$TAG/model-final.pth" ]; then
                    ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-c $SCRIPT  \
                        --data_path "datasets/imagenet_c/$DATASET/${tar}" \
                        --output_dir "checkpoints/TTT/${DATASET}_${tar}/$TAG" \
                        $EXTRA_ARGS
                fi
            done
        else
            for tar in 1 2 3 4 5; do
                if [ ! -f "checkpoints/TTT/${DATASET}_${tar}/$TAG/model-final.pth" ]; then
                    ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-c $SCRIPT  \
                        --data_path "datasets/imagenet_c/$DATASET/${tar}" \
                        --output_dir "checkpoints/TTT/${DATASET}_${tar}/$TAG" \
                        $EXTRA_ARGS
                fi
            done
        fi
    done

    # imagenet-o
    if [ ! -f "checkpoints/TTT/imagenet_o/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-oo $SCRIPT  \
            --data_path "datasets/imagenet_o" \
            --output_dir "checkpoints/TTT/imagenet_o/$TAG" \
            --dataset_name imagenet_o \
            $EXTRA_ARGS
    fi

    # imagenet-r
    if [ ! -f "checkpoints/TTT/imagenet_r/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-r $SCRIPT  \
            --data_path "datasets/imagenet_r" \
            --output_dir "checkpoints/TTT/imagenet_r/$TAG" \
            --dataset_name imagenet_r \
            $EXTRA_ARGS
    fi

    # imagenet-s
    if [ ! -f "checkpoints/TTT/imagenet_s/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-s $SCRIPT  \
            --data_path "datasets/imagenet_s" \
            --output_dir "checkpoints/TTT/imagenet_s/$TAG" \
            $EXTRA_ARGS
    fi

    # imagenet-v2-a
    if [ ! -f "checkpoints/TTT/imagenet_v2_match/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-v2-m $SCRIPT  \
            --data_path "datasets/imagenetv2-matched-frequency-format-val" \
            --output_dir "checkpoints/TTT/imagenet_v2_match/$TAG" \
            $EXTRA_ARGS
    fi

    # imagenet-v2-b
    if [ ! -f "checkpoints/TTT/imagenet_v2_thres/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-v2-s $SCRIPT  \
            --data_path "datasets/imagenetv2-threshold0.7-format-val" \
            --output_dir "checkpoints/TTT/imagenet_v2_thres/$TAG" \
            $EXTRA_ARGS
    fi

    # imagenet-v2-c
    if [ ! -f "checkpoints/TTT/imagenet_v2_top/$TAG/model-final.pth" ]; then
        ~/devfair/noder.sh 1 1 1 0 72 $QUEUE $LA in-v2-t $SCRIPT  \
            --data_path "datasets/imagenetv2-top-images-format-val" \
            --output_dir "checkpoints/TTT/imagenet_v2_top/$TAG" \
            $EXTRA_ARGS
    fi

}

###################################################
# 7/30/2022 - Rebuttal for COCO
##################################################
MODEL=mae_vit_large_patch16
MINI_FILE=checkpoints/meta/mini1000.npy
RESUME_MODEL=checkpoints_mae/converted/large_coco.pth
RESUME_FINETUNE_VIT_HEAD=checkpoints/coco_large_no_aug_lr1e-3_wd.5_dp.1_ep50/checkpoint-final.pth

TAG=coco-vit-head-sgd-large_75-20-steps-encoder-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_type 'sgd' \
--optimizer_momentum 0.0 \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

TAG=coco-vit-head-sgd-large_75-20-steps-all-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_momentum 0.0 \
--optimizer_type 'sgd' \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--finetune_mode 'all' \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

TAG=coco-vit-head-sgd-large_75-10-steps-encoder-mini
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 10 \
--optimizer_type 'sgd' \
--optimizer_momentum 0.0 \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--model $MODEL \
--minimizer ${MINI_FILE} \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

TAG=coco-vit-head-sgd-large_75-10-steps-all-mini
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 10 \
--optimizer_momentum 0.0 \
--optimizer_type 'sgd' \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--finetune_mode 'all' \
--model $MODEL \
--minimizer ${MINI_FILE} \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

# 7/18/2022, Huge
##################################################
MODEL=mae_vit_huge_patch14
RESUME_MODEL=checkpoints_mae/released/mae_pretrain_vit_huge_full.pth
RESUME_FINETUNE=checkpoints_mae/released/mae_linear_vit_huge.pth
RESUME_FINETUNE_VIT_HEAD=checkpoints/huge_no_aug_post_ddl_lr1e-3_wd.5_dp.1_ep50/checkpoint-final.pth
RESUME_FINETUNE_VIT_HEAD_AUG=checkpoints/huge_aug_post_ddl_lr1e-3_wd.3_dp.1_ep100/checkpoint-final.pth

TAG=vit-head-sgd-huge_75-20-steps-encoder-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_type 'sgd' \
--optimizer_momentum 0.0 \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

TAG=vit-head-sgd-huge_75-20-steps-all-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_momentum 0.0 \
--optimizer_type 'sgd' \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--finetune_mode 'all' \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"


# 7/6/2022 - For arxiving
##################################################
MODEL=mae_vit_large_patch16
RESUME_MODEL=checkpoints_mae/released/mae_pretrain_vit_large_full.pth
RESUME_FINETUNE=checkpoints_mae/released/mae_linear_vit_large.pth
RESUME_FINETUNE_VIT_HEAD=checkpoints/large_no_aug_post_ddl_lr1e-3_wd.5_dp.1_ep50/checkpoint-final.pth
RESUME_FINETUNE_VIT_HEAD_AUG=checkpoints/large_aug_post_ddl_lr1e-3_wd.3_dp.1_ep100/checkpoint-final.pth

TAG=vit-head-sgd-large_75-20-steps-encoder-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_type 'sgd' \
--optimizer_momentum 0.0 \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

TAG=vit-head-sgd-large_75-20-steps-all-m0
SHARED_ARGS=" \
--single_crop \
--batch_size 64 \
--accum_iter 2 \
--norm_pix_loss \
--mask_ratio 0.75 \
--steps_per_example 20 \
--optimizer_momentum 0.0 \
--optimizer_type 'sgd' \
--head_type 'vit_head' \
--classifier_depth 12 \
--blr 1e-2 \
--finetune_mode 'all' \
--model $MODEL \
--resume_model ${RESUME_MODEL} \
--resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
launch_function $TAG $script_file 0 "$SHARED_ARGS"

###################################################
# MODEL=mae_vit_large_patch16
# RESUME_MODEL=checkpoints_mae/released/mae_pretrain_vit_large_full.pth
# RESUME_FINETUNE=checkpoints_mae/released/mae_linear_vit_large.pth
# RESUME_FINETUNE_VIT_HEAD=checkpoints/share/prob_lr1e-3_wd.2_blk12_ep20.pth
# RESUME_FINETUNE_VIT_HEAD_AUG=checkpoints/share/aug_for_real_prob_lr1e-3_wd.5_dp.1_ep100.pth
# RESUME_FINETUNE_VIT_HEAD_AUG_V2=checkpoints/share/aug_for_real_prob_lr1e-4_wd.3_dp.1_ep50.pth
# RESUME_FINETUNE_VIT_HEAD_AUG_JOINT=checkpoints/share/joint_aug_lr1e-4_wd.05_ep100_mlc1..pth

# RESUME_VIS_MODEL=checkpoints_mae/released/mae_visualize_vit_large.pth
# RESUME_VIS_FINETUNE=checkpoints_mae/released/mae_vis_linear_vit_large.pth
# RESUME_VIS_FINETUNE_VIT_HEAD=checkpoints/share/vis_lr1e-3_wd.2_blk12_ep20.pth

# Joint model with aug
###################################################
# TAG=joint-vit-head-sgd-aug-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --finetune_mode 'encoder' \
# --model $MODEL \
# --resume_model ${RESUME_FINETUNE_VIT_HEAD_AUG_JOINT} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD_AUG_JOINT}" 
# launch_function $TAG $script_file 1 "$SHARED_ARGS"

# New ones on May 12
###################################################
# Please use the new 84.2 model for it
# TAG=vit-head-sgd-aug-large_75-encoder-10_steps
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --finetune_mode 'encoder' \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD_AUG_V2}" 
# launch_function $TAG $script_file 1 "$SHARED_ARGS"

# Fixed on May 11
###################################################
# TAG=vit-head-sgd-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-large_50-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.50 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# # New ones on May 9
# ###################################################
# TAG=vit-head-sgd-large_75-20-steps-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-large_75-20-steps-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --finetune_mode 'all' \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-large_90-20-steps-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.90 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-vis-large_90-20-steps-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.90 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-vis-large_90-20-steps-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.90 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --finetune_mode 'all' \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-large_95-20-steps-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.95 \
# --steps_per_example 20 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# # New ones on May 8
# ###################################################
# TAG=vit-head-sgd-aug-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --finetune_mode 'all' \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD_AUG}"
# launch_function $TAG $script_file 1 "$SHARED_ARGS"

# # New ones on May 5
# ###################################################
# TAG=vit-head-vis-adam_w-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-adam_w-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --finetune_mode 'all' \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# # ###################################################
# TAG=vit-head-vis-sgd-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-vis-sgd-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-sgd-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-2 \
# --finetune_mode 'all' \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-vis-adam-w-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_VIS_MODEL} \
# --resume_finetune ${RESUME_VIS_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-adam-w-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.75 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-adam-w-large_50-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.50 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-adam-w-large_25-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.25 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-head-adam-w-large_90-encoder
# SHARED_ARGS=" \
# --single_crop \
# --batch_size 64 \
# --accum_iter 2 \
# --norm_pix_loss \
# --mask_ratio 0.90 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'vit_head' \
# --classifier_depth 12 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE_VIT_HEAD}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-large_75-encoder
# SHARED_ARGS=" \
# --single_crop \
# --norm_pix_loss \
# --batch_size 64 \
# --accum_iter 2 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --head_type 'linear' \
# --mask_ratio 0.75 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-large_75-all
# SHARED_ARGS=" \
# --single_crop \
# --norm_pix_loss \
# --batch_size 64 \
# --accum_iter 2 \
# --steps_per_example 10 \
# --optimizer_type 'adam_w' \
# --finetune_mode 'all' \
# --head_type 'linear' \
# --mask_ratio 0.75 \
# --blr 1e-4 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-large_75_sgd
# SHARED_ARGS=" \
# --single_crop \
# --norm_pix_loss \
# --batch_size 64 \
# --accum_iter 2 \
# --steps_per_example 10 \
# --optimizer_type 'sgd' \
# --head_type 'linear' \
# --mask_ratio 0.75 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"

# TAG=vit-large_75_sgd-all
# SHARED_ARGS=" \
# --single_crop \
# --norm_pix_loss \
# --batch_size 64 \
# --accum_iter 2 \
# --steps_per_example 10 \
# --finetune_mode 'all' \
# --optimizer_type 'sgd' \
# --head_type 'linear' \
# --mask_ratio 0.75 \
# --blr 1e-2 \
# --model $MODEL \
# --resume_model ${RESUME_MODEL} \
# --resume_finetune ${RESUME_FINETUNE}"
# launch_function $TAG $script_file 0 "$SHARED_ARGS"
###################################################
rm -rf $script_file
echo ">>>>> $salt <<<<<"